﻿<?php


session_start();

$INDEX_ABS_URL     = '/novademo/html/demo1/index.php'; // absolute path to index
$HASH_FOR_FORGOT   = '#forgot';     // where enter-email.php lives inside index
$HASH_FOR_CHECK    = '#forgot';     // could be '#check-email' if you have a separate anchor

unset($_SESSION['enter_email_error'], $_SESSION['enter_email_value']);

function redirect_to_hash(string $indexUrl, string $hash): never {
    header('Location: ' . $indexUrl . $hash);
    exit;
}
function back_to_form_with_error(string $msg, ?string $email = null): never {
    global $INDEX_ABS_URL, $HASH_FOR_FORGOT;
    $_SESSION['enter_email_error'] = $msg;
    if ($email !== null) {
        $_SESSION['enter_email_value'] = $email;
    }
    redirect_to_hash($INDEX_ABS_URL, $HASH_FOR_FORGOT);
}
function go_to_check_email(): never {
    global $INDEX_ABS_URL, $HASH_FOR_CHECK;
    redirect_to_hash($INDEX_ABS_URL, $HASH_FOR_CHECK);
}

function generate_temp_password(int $length = 10): string {
    $raw = random_bytes(16);
    $b64 = rtrim(strtr(base64_encode($raw), '+/', '-_'), '=');
    while (strlen($b64) < $length) {
        $raw2 = random_bytes(8);
        $b64 .= rtrim(strtr(base64_encode($raw2), '+/', '-_'), '=');
    }
    return substr($b64, 0, $length);
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    back_to_form_with_error('Invalid request method. Please submit the form again.');
}

$email = trim($_POST['email'] ?? '');
if ($email === '') {
    back_to_form_with_error('Email is required.', $email);
}
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    back_to_form_with_error('Please enter a valid email address.', $email);
}

$configPath = __DIR__ . '/../../../config.php';
if (!is_file($configPath)) {
    back_to_form_with_error('Database configuration missing. Please contact support.', $email);
}
require_once $configPath;

$pdo = $pdo ?? null;
if (!$pdo instanceof PDO && function_exists('get_pdo')) {
    $pdo = get_pdo();
}
if (!$pdo instanceof PDO && defined('DB_HOST') && defined('DB_NAME') && defined('DB_USER') && defined('DB_PASS')) {
    try {
        $pdo = new PDO(
            'mysql:host=' . DB_HOST . ';dbname=' . DB_NAME . ';charset=utf8mb4',
            DB_USER,
            DB_PASS,
            [
                PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES   => false,
            ]
        );
    } catch (Throwable $e) {
        back_to_form_with_error('Database connection failed. Please try again later.', $email);
    }
}
if (!$pdo instanceof PDO) {
    $dbArray = null;
    if (isset($db) && is_array($db)) $dbArray = $db;
    elseif (isset($config['db']) && is_array($config['db'])) $dbArray = $config['db'];

    if ($dbArray) {
        $host = $dbArray['host'] ?? $dbArray['server'] ?? null;
        $name = $dbArray['name'] ?? $dbArray['dbname'] ?? null;
        $user = $dbArray['user'] ?? $dbArray['username'] ?? null;
        $pass = $dbArray['pass'] ?? $dbArray['password'] ?? null;
        if ($host && $name && $user && $pass) {
            try {
                $pdo = new PDO(
                    "mysql:host={$host};dbname={$name};charset=utf8mb4",
                    $user,
                    $pass,
                    [
                        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
                        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                        PDO::ATTR_EMULATE_PREPARES   => false,
                    ]
                );
            } catch (Throwable $e) {
                back_to_form_with_error('Database connection failed. Please try again later.', $email);
            }
        }
    }
}
if (!$pdo instanceof PDO) {
    back_to_form_with_error('Database configuration is invalid. Please contact support.', $email);
}

$usersTable = defined('USERS_TABLE') ? USERS_TABLE : 'users';
$usersTable = preg_replace('/[^a-zA-Z0-9_]/', '', (string)$usersTable) ?: 'users';

try {
    $stmt = $pdo->prepare("SELECT `id` FROM `{$usersTable}` WHERE `email` = ? LIMIT 1");
    $stmt->execute([$email]);
    $user = $stmt->fetch();
} catch (PDOException $e) {
    error_log('[enter-email.process.php] PDO lookup error: ' . $e->getMessage());
    $msg = 'A database error occurred. Please try again.';
    $mysqlErrNo = $e->errorInfo[1] ?? null;
    if (defined('APP_DEBUG') && APP_DEBUG && $mysqlErrNo === 1146) {
        $msg .= " (Table `{$usersTable}` not found. If yours is different, define('USERS_TABLE','your_table') in config.php.)";
    }
    back_to_form_with_error($msg, $email);
}

if (!$user) {
    back_to_form_with_error('We couldn’t find that email address in our system.', $email);
}

$tempPassword = generate_temp_password(10);
$hashedTemp   = password_hash($tempPassword, PASSWORD_BCRYPT);

$subject   = 'Temporary Password - Nova Chain Investments';
$loginUrl  = 'https://localhost/novademo/html/demo1/authentication/classic/sign-in.php'; // adjust if needed
$body      = "Hello,\n\n"
           . "You requested a password reset. We generated a temporary password for your account:\n\n"
           . "Temporary password: {$tempPassword}\n\n"
           . "Please log in using this password and change it immediately in your profile/security settings.\n\n"
           . "Login: {$loginUrl}\n\n"
           . "If you did not request this, please contact support.\n\n"
           . "— Nova Chain Investments";
$fromEmail = 'test@test.com';
$fromName  = 'Nova Chain Investments';

$headers  = 'From: ' . sprintf('%s <%s>', $fromName, $fromEmail) . "\r\n";
$headers .= 'Reply-To: ' . $fromEmail . "\r\n";
$headers .= 'Content-Type: text/plain; charset=UTF-8' . "\r\n";

try {
    if (!$pdo->inTransaction()) {
        $pdo->beginTransaction();
    }

    $update = $pdo->prepare("UPDATE `{$usersTable}` SET `password` = ? WHERE `id` = ? LIMIT 1");
    $update->execute([$hashedTemp, $user['id']]);

    $sent = @mail($email, $subject, $body, $headers);

    if (!$sent) {
        $pdo->rollBack();
        back_to_form_with_error('We couldn’t send the reset email right now. Please try again later.', $email);
    }

    $pdo->commit();

} catch (PDOException $e) {
    if ($pdo->inTransaction()) {
        $pdo->rollBack();
    }
    error_log('[enter-email.process.php] PDO update error: ' . $e->getMessage());
    back_to_form_with_error('We couldn’t update your account at this time. Please try again later.', $email);
} catch (Throwable $e) {
    if ($pdo->inTransaction()) {
        $pdo->rollBack();
    }
    error_log('[enter-email.process.php] General error: ' . $e->getMessage());
    back_to_form_with_error('Unexpected error occurred. Please try again later.', $email);
}

go_to_check_email();
